package de.fhdw.gaming.ipspiel22.kopfundzahl.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;

/**
 * Represents a player for the head and tail game.
 */
public interface KopfundZahlPlayer extends Player<KopfundZahlPlayer> {

    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<Boolean, Map<Boolean, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player. {@code true} means "Head", {@code false} means "tail".
     */
    Optional<Boolean> getAnswer();

    /**
     * Sets the answer of this player.
     *
     * @param newAnswer The answer to set. {@code true} means "Head", {@code false} means "tail".
     * @throws IllegalStateException if an answer has already been set.
     */
    void setAnswer(boolean newAnswer);
}
