package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;

/**
 * Implements {@link VGPlayer}.
 */
public class VGPlayerImpl extends AbstractPlayer<VGPlayer> implements VGPlayer {

    /**
     * {@code true} if this player uses the red tokens, or {@code false} if she uses the yellow tokens.
     */
    private final boolean usingRedChips;

    /**
     * Creates a Vier gewinnt player.
     *
     * @param name          The name of the player.
     * @param usingRedChips The possible outcomes of this player. The key for the first-level map is the answer of
     *                      the first player, the key for the second-level map is the answer of the second player.
     */
    VGPlayerImpl(final String name, final boolean usingRedChips) {
        super(name);
        this.usingRedChips = usingRedChips;
    }

    /**
     * Creates a Vier gewinnt player.
     *
     * @param source The {@link VGPlayer} to copy.
     */
    VGPlayerImpl(final VGPlayer source) {
        super(source);
        this.usingRedChips = source.isUsingRedChips();
    }

    @Override
    public String toString() {
        return String
                .format("GDPlayer[name=%s, chips=%s, state=%s, outcome=%s]",
                        this.getName(),
                        this.usingRedChips ? VGFieldState.RED.toString() : VGFieldState.YELLOW.toString(),
                        this.getState(), this.getOutcome());
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof VGPlayerImpl) {
            final VGPlayerImpl other = (VGPlayerImpl) obj;
            return super.equals(obj) && this.usingRedChips == other.usingRedChips;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Boolean.hashCode(this.usingRedChips);
    }

    @Override
    public boolean isUsingRedChips() {
        return this.usingRedChips;
    }

    @Override
    public VGPlayer deepCopy() {
        return new VGPlayerImpl(this);
    }
}
