package de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl;

import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is solely to be able to check whether a {@link VGMove} implementation is allowed by the
 * rules of the game. As this class is not public, custom strategies are unable to create {@link VGMove} objects that
 * inherit from this class, so custom moves can be distinguished from possible moves easily.
 */
public abstract class AbstractVGMove implements VGMove {
    /**
     * Protected constructor.
     */
    protected AbstractVGMove() {
        // nothing to do
    }

    /**
     * Returns Column Int.
     * 
     * @return Column int
     */
    public abstract int getColumnInt();
}
