/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.VGStrategyEins.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel22.searchtree.domain.MinMaxGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG1ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG2ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG3ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG4ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG5ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG6ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG7ColumnMove;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Bewertung
implements MinMaxGame<VGPlayer, VGState, VGMove> {
    private final VGPlayer player;
    private VGState state;
    private final VGMoveFactory movesFactory;
    private final VGMove firstColumn;
    private final VGMove secondColumn;
    private final VGMove thirdColumn;
    private final VGMove fourthColumn;
    private final VGMove fifthColumn;
    private final VGMove sixthColumn;
    private final VGMove seventhColumn;
    private final List<VGState> states = new ArrayList<VGState>();

    public Bewertung(VGPlayer player, VGState state, VGMoveFactory movesFactory) {
        this.player = player;
        this.state = state;
        this.movesFactory = movesFactory;
        this.firstColumn = movesFactory.createFirstColumnMove();
        this.secondColumn = movesFactory.createSecondColumnMove();
        this.thirdColumn = movesFactory.createThirdColumnMove();
        this.fourthColumn = movesFactory.createFourthColumnMove();
        this.fifthColumn = movesFactory.createFifthColumnMove();
        this.sixthColumn = movesFactory.createSixthColumnMove();
        this.seventhColumn = movesFactory.createSeventhColumnMove();
    }

    public double evaluateStateful() {
        VGPlayer currentPlayer = this.state.getCurrentPlayer();
        VGBoard board = this.state.getBoard();
        List fields = board.getFields();
        ArrayList<VGField> fieldWithRed = new ArrayList<VGField>();
        ArrayList<VGField> fieldWithYellow = new ArrayList<VGField>();
        for (List i : fields) {
            for (VGField m : i) {
                if (m.getState() == VGFieldState.RED) {
                    fieldWithRed.add(m);
                    continue;
                }
                if (m.getState() != VGFieldState.YELLOW) continue;
                fieldWithYellow.add(m);
            }
        }
        int redPlayerScore = this.calcPlayerPoints(fieldWithRed);
        int yellowPlayerScore = this.calcPlayerPoints(fieldWithRed);
        if (currentPlayer.isUsingRedChips()) {
            return redPlayerScore;
        }
        return yellowPlayerScore;
    }

    private int calcPlayerPoints(List<VGField> positions) {
        int score = 0;
        for (VGField vgField : positions) {
            score += this.checkIfPositionWorth13(vgField);
        }
        return score;
    }

    private int checkIfPositionWorth13(VGField vgField) {
        ArrayList<VGPosition> punkteDreizehn = new ArrayList<VGPosition>();
        punkteDreizehn.add(new VGPosition(3, 2));
        punkteDreizehn.add(new VGPosition(3, 3));
        if (punkteDreizehn.contains(vgField.getPosition())) {
            return 13;
        }
        return this.checkIfPositionWorth11(vgField);
    }

    private int checkIfPositionWorth11(VGField vgField) {
        ArrayList<VGPosition> punkteElf = new ArrayList<VGPosition>();
        punkteElf.add(new VGPosition(2, 3));
        punkteElf.add(new VGPosition(2, 2));
        punkteElf.add(new VGPosition(4, 2));
        punkteElf.add(new VGPosition(4, 3));
        if (punkteElf.contains(vgField.getPosition())) {
            return 11;
        }
        return this.checkIfPositionWorth8(vgField);
    }

    private int checkIfPositionWorth8(VGField vgField) {
        ArrayList<VGPosition> punkteAcht = new ArrayList<VGPosition>();
        punkteAcht.add(new VGPosition(3, 4));
        punkteAcht.add(new VGPosition(3, 1));
        if (punkteAcht.contains(vgField.getPosition())) {
            return 8;
        }
        return this.checkIfPositionWorth7(vgField);
    }

    private int checkIfPositionWorth7(VGField vgField) {
        ArrayList<VGPosition> punkteSieben = new ArrayList<VGPosition>();
        punkteSieben.add(new VGPosition(1, 2));
        punkteSieben.add(new VGPosition(1, 3));
        punkteSieben.add(new VGPosition(2, 1));
        punkteSieben.add(new VGPosition(2, 4));
        punkteSieben.add(new VGPosition(3, 5));
        punkteSieben.add(new VGPosition(3, 0));
        punkteSieben.add(new VGPosition(4, 4));
        punkteSieben.add(new VGPosition(4, 1));
        punkteSieben.add(new VGPosition(5, 3));
        punkteSieben.add(new VGPosition(5, 2));
        if (punkteSieben.contains(vgField.getPosition())) {
            return 7;
        }
        return this.checkIfPositionWorth6(vgField);
    }

    private int checkIfPositionWorth6(VGField vgField) {
        ArrayList<VGPosition> punkteSechs = new ArrayList<VGPosition>();
        punkteSechs.add(new VGPosition(1, 1));
        punkteSechs.add(new VGPosition(1, 4));
        punkteSechs.add(new VGPosition(5, 1));
        punkteSechs.add(new VGPosition(5, 4));
        if (punkteSechs.contains(vgField.getPosition())) {
            return 6;
        }
        return this.checkIfPositionWorth5(vgField);
    }

    private int checkIfPositionWorth5(VGField vgField) {
        ArrayList<VGPosition> punkteFuenf = new ArrayList<VGPosition>();
        punkteFuenf.add(new VGPosition(0, 3));
        punkteFuenf.add(new VGPosition(0, 2));
        punkteFuenf.add(new VGPosition(2, 0));
        punkteFuenf.add(new VGPosition(2, 5));
        punkteFuenf.add(new VGPosition(4, 0));
        punkteFuenf.add(new VGPosition(4, 5));
        punkteFuenf.add(new VGPosition(6, 2));
        punkteFuenf.add(new VGPosition(6, 3));
        if (punkteFuenf.contains(vgField.getPosition())) {
            return 5;
        }
        return this.checkIfPositionWorth4(vgField);
    }

    private int checkIfPositionWorth4(VGField vgField) {
        ArrayList<VGPosition> punkteVier = new ArrayList<VGPosition>();
        punkteVier.add(new VGPosition(0, 1));
        punkteVier.add(new VGPosition(0, 4));
        punkteVier.add(new VGPosition(1, 0));
        punkteVier.add(new VGPosition(1, 5));
        punkteVier.add(new VGPosition(5, 5));
        punkteVier.add(new VGPosition(5, 0));
        punkteVier.add(new VGPosition(6, 4));
        punkteVier.add(new VGPosition(6, 1));
        if (punkteVier.contains(vgField.getPosition())) {
            return 4;
        }
        return this.checkIfPositionWorth3(vgField);
    }

    private int checkIfPositionWorth3(VGField vgField) {
        ArrayList<VGPosition> punkteDrei = new ArrayList<VGPosition>();
        punkteDrei.add(new VGPosition(0, 0));
        punkteDrei.add(new VGPosition(0, 5));
        punkteDrei.add(new VGPosition(6, 0));
        punkteDrei.add(new VGPosition(6, 5));
        if (punkteDrei.contains(vgField.getPosition())) {
            return 3;
        }
        return 0;
    }

    public boolean isGameOver() {
        return this.player.getState() != PlayerState.PLAYING;
    }

    public List<VGMove> getPossibleMoves() {
        ArrayList<VGMove> possibleMoves = new ArrayList<VGMove>();
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN))) {
            possibleMoves.add((VGMove)new VG1ColumnMove());
        }
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN))) {
            possibleMoves.add((VGMove)new VG2ColumnMove());
        }
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN))) {
            possibleMoves.add((VGMove)new VG3ColumnMove());
        }
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN))) {
            possibleMoves.add((VGMove)new VG4ColumnMove());
        }
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN))) {
            possibleMoves.add((VGMove)new VG5ColumnMove());
        }
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN))) {
            possibleMoves.add((VGMove)new VG6ColumnMove());
        }
        if (Objects.nonNull(this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN))) {
            possibleMoves.add((VGMove)new VG7ColumnMove());
        }
        Collections.shuffle(possibleMoves);
        return possibleMoves;
    }

    public void commitMove(VGMove move) throws GameException {
        this.states.add(this.state);
        if (move.equals(this.firstColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN).getPosition());
        } else if (move.equals(this.secondColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN).getPosition());
        } else if (move.equals(this.thirdColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN).getPosition());
        } else if (move.equals(this.fourthColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN).getPosition());
        } else if (move.equals(this.fifthColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN).getPosition());
        } else if (move.equals(this.sixthColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN).getPosition());
        } else if (move.equals(this.seventhColumn)) {
            this.movesFactory.createTokenMove(this.player.isUsingRedChips(), this.state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN).getPosition());
        }
    }

    public void rollbackMove(VGMove move) {
        this.state = this.states.get(0);
    }
}

