package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a Gefangenen Dilemma player.
 */
public interface GDPlayerBuilder {
    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     *
     * @param newName The name of the player.
     * @return {@code this}
     */
    GDPlayerBuilder changeName(String newName);

    /**
     * Changes the possible outcomes of the player.
     * <p>
     * There is no default.
     *
     * @param possibleOutcomes The possible outcomes of the player. The key for the first-level map is the answer of the
     *                         first player, the key for the second-level map is the answer of the second player.
     */
    GDPlayerBuilder changePossibleOutcomes(Map<Boolean, Map<Boolean, Double>> possibleOutcomes);

    /**
     * Builds the player.
     *
     * @return The Gefangenen Dilemma player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    GDPlayer build() throws GameException;
}
