package de.fhdw.gaming.ipspiel22.vierGewinnt.domain;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a Vier gewinnt player.
 */
public interface VGPlayerBuilder {
    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     *
     * @param newName The name of the player.
     * @return {@code this}
     */
    VGPlayerBuilder changeName(String newName);

    /**
     * Determines whether the player is using red or yellow tokens.<
     * <p>
     * The default value if not called is {@code true}.
     *
     * @param newUsingRedChips If {@code true}, the player will be using red tokens, else she will be using yellow
     *                            tokens.
     * @return {@code this}
     */
    VGPlayerBuilder changeUsingRedChips(boolean newUsingRedChips);

    /**
     * Returns {@code true} if this player builder uses the red tokens, and {@code false} if she uses the yellow
     * tokens.
     */
    boolean isUsingRedChips();

    /**
     * Builds the player.
     *
     * @return The Vier gewinnt player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    VGPlayer build() throws GameException;
}
