/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.tictactoe.gui.impl;

import de.fhdw.gaming.ipspiel22.tictactoe.core.domain.TicTacToeFieldState;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

final class TicTacToeFieldView
extends Region {
    private TicTacToeFieldState fieldState;
    private final Canvas canvas;
    private final ObjectProperty<Duration> moveDuration;
    private boolean highlighted;

    TicTacToeFieldView(TicTacToeFieldState fieldState) {
        this.fieldState = fieldState;
        this.moveDuration = new SimpleObjectProperty((Object)Duration.millis((double)500.0));
        this.highlighted = false;
        this.canvas = new Canvas(){

            public boolean isResizable() {
                return true;
            }

            public double prefWidth(double height) {
                return 0.0;
            }

            public double prefHeight(double width) {
                return 0.0;
            }

            public double maxWidth(double height) {
                return Double.POSITIVE_INFINITY;
            }

            public double maxHeight(double width) {
                return Double.POSITIVE_INFINITY;
            }
        };
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.setMinSize(50.0, 50.0);
        this.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    void setFieldState(TicTacToeFieldState fieldState) {
        this.fieldState = fieldState;
        this.draw();
    }

    void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.draw();
    }

    private void draw() {
        double size = this.getWidth();
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setFill((Paint)(this.highlighted ? Color.GREEN : Color.DARKOLIVEGREEN));
        gc.fillRect(0.0, 0.0, size, size);
        gc.setFill((Paint)Color.BLACK);
        gc.beginPath();
        gc.moveTo(0.0, 0.0);
        gc.lineTo(size, 0.0);
        gc.lineTo(size, size);
        gc.lineTo(0.0, size);
        gc.lineTo(0.0, 0.0);
        gc.closePath();
        gc.stroke();
        double margin = size * 0.1;
        switch (this.fieldState) {
            case EMPTY: {
                break;
            }
            case CROSS: {
                gc.setFill((Paint)Color.BLACK);
                gc.beginPath();
                gc.moveTo(margin, margin);
                gc.lineTo(size - margin, size - margin);
                gc.moveTo(margin, size - margin);
                gc.lineTo(size - margin, margin);
                gc.closePath();
                gc.stroke();
                break;
            }
            case NOUGHT: {
                gc.setFill((Paint)Color.WHITE);
                gc.strokeOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown Tic Tac Toe field state '%s'.", this.fieldState));
            }
        }
    }
}

