package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Gefangenen Dilemma {@link GameBuilderFactory} which allows to create a Gefangenen Dilemma game builder.
 */
public interface GDGameBuilderFactory extends GameBuilderFactory {
    /**
     * Player's outcome on Statement/Statement.
     */
    String PARAM_PLAYER_OUTCOME_ON_STATEM_STATEM = "playerOutcomeOnStatementStatement";

    /**
     * Player's outcome on Statement/Quiet.
     */
    String PARAM_PLAYER_OUTCOME_ON_STATEM_QUIET = "playerOutcomeOnStatementQuiet";

    /**
     * Player's outcome on Quiet/Statement.
     */
    String PARAM_PLAYER_OUTCOME_ON_QUIET_STATEM = "playerOutcomeOnQuietStatement";

    /**
     * Player's outcome on Quiet/Quiet.
     */
    String PARAM_PLAYER_OUTCOME_ON_QUIET_QUIET = "playerOutcomeOnQuietQuiet";

    @Override
    GDGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
