package de.fhdw.gaming.ipspiel22.gefangenenDilemma.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDState;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.GDMove;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.factory.GDMoveFactory;

/**
 * Implements {@link GDStrategy} by always staying "quiet".
 */
public class GDQuietStrategy implements GDStrategy {
    /**
     * The factory for creating Gefangenen Dilemma moves.
     */
    private final GDMoveFactory moveFactory;

    /**
     * Creates an {@link GDQuietStrategy}.
     *
     * @param moveFactory The factory for creating Gefangenen Dilemma moves.
     */
    public GDQuietStrategy(final GDMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<GDMove> computeNextMove(final int gameId, final GDPlayer player, final GDState state) {
        return Optional.of(this.moveFactory.createQuietMove());
    }

    @Override
    public String toString() {
        return GDQuietStrategy.class.getSimpleName();
    }
}
