package de.fhdw.gaming.ipspiel22.vierGewinnt.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.searchtree.algorithm.MinMaxAlgorithm;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;

/**
 * Best Strategy by using the MinMaxAlgorithm.
 */
public class MinMaxVGStrategy implements VGStrategy {

    @Override
    public Optional<VGMove> computeNextMove(final int gameId, final VGPlayer player, final VGState state)
            throws GameException {
        final MinMaxViergewinnt vg = new MinMaxViergewinnt(state, player);
        final MinMaxAlgorithm<VGPlayer, VGState, VGMove, MinMaxViergewinnt> minmax = new MinMaxAlgorithm<>(vg);

        return minmax.getBestMove(5);
    }

    @Override
    public String toString() {
        return MinMaxVGStrategy.class.getSimpleName();
    }
}
