package de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.impl;

import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.GDMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is solely to be able to check whether a {@link GDMove} implementation is allowed by the
 * rules of the game. As this class is not exported, custom strategies are unable to create {@link GDMove} objects that
 * inherit from this class, so custom moves can be distinguished from possible moves easily.
 */
public abstract class AbstractGDMove implements GDMove {
    /**
     * Protected constructor.
     */
    protected AbstractGDMove() {
        // nothing to do
    }
}
