/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDGameBuilder;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDGameBuilderFactory;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayerBuilder;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.factory.GDDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.factory.GDStrategyFactory;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.factory.GDStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl.GDGameBuilderImpl;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.impl.GDDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class GDGameBuilderFactoryImpl
implements GDGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<GDStrategy> strategies;

    public GDGameBuilderFactoryImpl() {
        this(new GDDefaultStrategyFactoryProvider());
    }

    GDGameBuilderFactoryImpl(GDStrategyFactoryProvider strategyFactoryProvider) {
        GDDefaultMoveFactory moveFactory = new GDDefaultMoveFactory();
        List<GDStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<GDStrategy>();
        for (GDStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Gefangenen Dilemma";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<GDStrategy>(this.strategies);
    }

    @Override
    public GDGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            GDGameBuilderImpl gameBuilder = new GDGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            GDPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            GDStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            GDPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            GDStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Gefangenen Dilemma game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        if (title.equals("Player 1")) {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnStatementStatement", "Player's outcome on Statement/Statement", Optional.of(-8), new Validator[0]).needInteger("playerOutcomeOnStatementQuiet", "Player's outcome on Statement/Quiet", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnQuietStatement", "Player's outcome on Quiet/Statement", Optional.of(-10), new Validator[0]).needInteger("playerOutcomeOnQuietQuiet", "Player's outcome on Quiet/Quiet", Optional.of(-1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        } else {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnStatementStatement", "Player's outcome on Statement/Statement", Optional.of(-8), new Validator[0]).needInteger("playerOutcomeOnStatementQuiet", "Player's outcome on Statement/Quiet", Optional.of(-10), new Validator[0]).needInteger("playerOutcomeOnQuietStatement", "Player's outcome on Quiet/Statement", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnQuietQuiet", "Player's outcome on Quiet/Quiet", Optional.of(-1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        }
        return inputProvider.requestData(title);
    }

    private GDPlayer createPlayer(GDPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<Boolean, Map<Boolean, Double>> possibleOutcomes = new LinkedHashMap<Boolean, Map<Boolean, Double>>();
        LinkedHashMap<Boolean, Double> possibleOutcomesStatement = new LinkedHashMap<Boolean, Double>();
        possibleOutcomesStatement.put(Boolean.FALSE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnStatementStatement")).intValue()));
        possibleOutcomesStatement.put(Boolean.TRUE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnStatementQuiet")).intValue()));
        possibleOutcomes.put(Boolean.FALSE, possibleOutcomesStatement);
        LinkedHashMap<Boolean, Double> possibleOutcomesQuiet = new LinkedHashMap<Boolean, Double>();
        possibleOutcomesQuiet.put(Boolean.FALSE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnQuietStatement")).intValue()));
        possibleOutcomesQuiet.put(Boolean.TRUE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnQuietQuiet")).intValue()));
        possibleOutcomes.put(Boolean.TRUE, possibleOutcomesQuiet);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private GDStrategy getStrategy(Map<String, Object> playerData) {
        return (GDStrategy)playerData.get("playerStrategy");
    }
}

