/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayerBuilder;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl.GDPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class GDPlayerBuilderImpl
implements GDPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<Boolean, Map<Boolean, Double>>> possibleOutcomes = Optional.empty();

    GDPlayerBuilderImpl() {
    }

    @Override
    public GDPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public GDPlayerBuilder changePossibleOutcomes(Map<Boolean, Map<Boolean, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public GDPlayer build() throws GameException {
        return new GDPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<Boolean, Map<Boolean, Double>> checkPossibleOutcomes(Map<Boolean, Map<Boolean, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, false, false);
        this.checkPossibleOutcome(outcomes, false, true);
        this.checkPossibleOutcome(outcomes, true, false);
        this.checkPossibleOutcome(outcomes, true, true);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<Boolean, Map<Boolean, Double>> outcomes, boolean firstChoice, boolean secondChoice) {
        if (outcomes.getOrDefault(firstChoice, Collections.emptyMap()).get(secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, GDPlayerBuilderImpl.toAnswer(firstChoice), GDPlayerBuilderImpl.toAnswer(secondChoice)));
        }
    }

    static String toAnswer(boolean value) {
        return value ? "quiet" : "statement";
    }
}

