package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Gefangenen Dilemma game.
 */
public interface GDGameBuilder extends GameBuilder {
    /**
     * Creates an {@link GDPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    GDPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    GDGameBuilder addPlayer(GDPlayer player, GDStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */
    GDGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    GDGame build(int id) throws GameException, InterruptedException;
}
