/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlGameBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlGameBuilderFactory;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayerBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.factory.KopfundZahlDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.factory.KopfundZahlStrategyFactory;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl.KopfundZahlGameBuilderImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.impl.DefaultKopfundZahlMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class KopfundZahlGameBuilderFactoryImpl
implements KopfundZahlGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<KopfundZahlStrategy> strategies;

    public KopfundZahlGameBuilderFactoryImpl() {
        this(new KopfundZahlDefaultStrategyFactoryProvider());
    }

    KopfundZahlGameBuilderFactoryImpl(KopfundZahlDefaultStrategyFactoryProvider strategyFactoryProvider) {
        DefaultKopfundZahlMoveFactory moveFactory = new DefaultKopfundZahlMoveFactory();
        List<KopfundZahlStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<KopfundZahlStrategy>();
        for (KopfundZahlStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "KopfundZahl";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<KopfundZahlStrategy>(this.strategies);
    }

    @Override
    public KopfundZahlGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            KopfundZahlGameBuilderImpl gameBuilder = new KopfundZahlGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            KopfundZahlPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            KopfundZahlStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            KopfundZahlPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            KopfundZahlStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating KopfundZahl game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        if (title.equals("Player 1")) {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnTailTail", "Player's outcome on Tail/Tail", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnTailHead", "Player's outcome on Tail/Head", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnHeadTail", "Player's outcome on Head/Tail", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnHeadHead", "Player's outcome on Head/Head", Optional.of(1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        } else {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnTailTail", "Player's outcome on Tail/Tail", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnTailHead", "Player's outcome on Tail/Head", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnHeadTail", "Player's outcome on Head/Tail", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnHeadHead", "Player's outcome on Head/Head", Optional.of(-1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        }
        return inputProvider.requestData(title);
    }

    private KopfundZahlPlayer createPlayer(KopfundZahlPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<Boolean, Map<Boolean, Double>> possibleOutcomes = new LinkedHashMap<Boolean, Map<Boolean, Double>>();
        LinkedHashMap<Boolean, Double> possibleOutcomesNo = new LinkedHashMap<Boolean, Double>();
        possibleOutcomesNo.put(Boolean.FALSE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnTailTail")).intValue()));
        possibleOutcomesNo.put(Boolean.TRUE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnTailHead")).intValue()));
        possibleOutcomes.put(Boolean.FALSE, possibleOutcomesNo);
        LinkedHashMap<Boolean, Double> possibleOutcomesYes = new LinkedHashMap<Boolean, Double>();
        possibleOutcomesYes.put(Boolean.FALSE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnHeadTail")).intValue()));
        possibleOutcomesYes.put(Boolean.TRUE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnHeadHead")).intValue()));
        possibleOutcomes.put(Boolean.TRUE, possibleOutcomesYes);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private KopfundZahlStrategy getStrategy(Map<String, Object> playerData) {
        return (KopfundZahlStrategy)playerData.get("playerStrategy");
    }
}

