/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class KopfundZahlPlayerImpl
extends AbstractPlayer<KopfundZahlPlayer>
implements KopfundZahlPlayer {
    private final Map<Boolean, Map<Boolean, Double>> possibleOutcomes;
    private Optional<Boolean> answer;

    public KopfundZahlPlayerImpl(String name, Map<Boolean, Map<Boolean, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<Boolean, Map<Boolean, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    KopfundZahlPlayerImpl(KopfundZahlPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("KopfundZahlPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfundZahlPlayerImpl) {
            KopfundZahlPlayerImpl other = (KopfundZahlPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Map<Boolean, Map<Boolean, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<Boolean> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(boolean newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    public KopfundZahlPlayer deepCopy() {
        return new KopfundZahlPlayerImpl(this);
    }
}

