package de.fhdw.gaming.ipspiel22.kopfundzahl.moves.impl;

import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.KopfundZahlMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is solely to be able to check whether a {@link KopfundZahlMove}
 * implementation is allowed by the rules of the game. As this class is not exported, custom
 * strategies are unable to create {@link KopfundZahlMove} objects that inherit from this class,
 * so custom moves can be distinguished from possible moves easily.
 */
public abstract class AbstractKopfundZahlMove implements KopfundZahlMove {

    /**
     * Protected constructor.
     */
    protected AbstractKopfundZahlMove() {
        // Nothing to do
    }
}
