package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Head and Tail game.
 */
public interface KopfundZahlundKanteGameBuilder extends GameBuilder {

    /**
     * Creates an {@link KopfundZahlundKantePlayerBuilder} which allows to create and add a player
     * to the game together with their strategy.
     */
    KopfundZahlundKantePlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    KopfundZahlundKanteGameBuilder addPlayer(KopfundZahlundKantePlayer player, KopfundZahlundKanteStrategy strategy)
            throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */

    KopfundZahlundKanteGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    KopfundZahlundKanteGame build(int id) throws GameException, InterruptedException;
}
