package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.impl;

import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.KopfundZahlundKanteMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is solely to be able to check whether a {@link KopfundZahlundKanteMove}
 * implementation is allowed by the rules of the game. As this class is not exported, custom
 * strategies are unable to create {@link KopfundZahlundKanteMove} objects that inherit from this class,
 * so custom moves can be distinguished from possible moves easily.
 */
public abstract class AbstractKopfundZahlundKanteMove implements KopfundZahlundKanteMove {

    /**
     * Protected constructor.
     */
    protected AbstractKopfundZahlundKanteMove() {
        // Nothing to do
    }
}
