package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;

/**
 * Represents a player for the head and tail game.
 */
public interface KopfundZahlundKantePlayer extends Player<KopfundZahlundKantePlayer> {

    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player.
     */
    Optional<KopfundZahlundKanteAnswerEnum> getAnswer();

    /**
     * Records the answer of this player.
     *
     * @param answer The player's answer uses enum KopfundZahlAnswerEnum.
     */
    void setAnswer(KopfundZahlundKanteAnswerEnum answer);
}
