/*
 * Decompiled with CFR 0.152.
 */
package de.schereSteinPapier.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.schereSteinPapier.domain.SSPGameBuilder;
import de.schereSteinPapier.domain.SSPGameBuilderFactory;
import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPPlayerBuilder;
import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.domain.factory.SSPDefaultStrategyFactoryProvider;
import de.schereSteinPapier.domain.factory.SSPStrategyFactory;
import de.schereSteinPapier.domain.factory.SSPStrategyFactoryProvider;
import de.schereSteinPapier.domain.impl.SSPGameBuilderImpl;
import de.schereSteinPapier.moves.impl.SSPDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class SSPGameBuilderFactoryImpl
implements SSPGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<SSPStrategy> strategies;

    public SSPGameBuilderFactoryImpl() {
        this(new SSPDefaultStrategyFactoryProvider());
    }

    SSPGameBuilderFactoryImpl(SSPStrategyFactoryProvider strategyFactoryProvider) {
        SSPDefaultMoveFactory moveFactory = new SSPDefaultMoveFactory();
        List<SSPStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<SSPStrategy>();
        for (SSPStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "SSP";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<SSPStrategy>(this.strategies);
    }

    @Override
    public SSPGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            SSPGameBuilderImpl gameBuilder = new SSPGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            SSPPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            SSPStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            SSPPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            SSPStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Demo game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        if (title.equals("Player 1")) {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnSchereSchere", "Player's outcome on Schere/Schere", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSchereStein", "Player's outcome on Schere/Stein", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnScherePapier", "Player's outcome on Schere/Papier", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnSteinSchere", "Player's outcome on Stein/Schere", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnSteinStein", "Player's outcome on Stein/Stein", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSteinPapier", "Player's outcome on Stein/Papier", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnPapierSchere", "Player's outcome on Papier/Schere", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnPapierStein", "Player's outcome on Papier/Stein", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnPapierPapier", "Player's outcome on Papier/Papier", Optional.of(0), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        } else {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnSchereSchere", "Player's outcome on Schere/Schere", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSchereStein", "Player's outcome on Schere/Stein", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnScherePapier", "Player's outcome on Schere/Papier", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnSteinSchere", "Player's outcome on Stein/Schere", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnSteinStein", "Player's outcome on Stein/Stein", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnSteinPapier", "Player's outcome on Stein/Papier", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnPapierSchere", "Player's outcome on Papier/Schere", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnPapierStein", "Player's outcome on Papier/Stein", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnPapierPapier", "Player's outcome on Papier/Papier", Optional.of(0), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        }
        return inputProvider.requestData(title);
    }

    private SSPPlayer createPlayer(SSPPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<String, Map<String, Double>> possibleOutcomes = new LinkedHashMap<String, Map<String, Double>>();
        LinkedHashMap<String, Double> possibleOutcomesSchere = new LinkedHashMap<String, Double>();
        possibleOutcomesSchere.put("Schere", Double.valueOf(((Integer)playerData.get("playerOutcomeOnSchereSchere")).intValue()));
        possibleOutcomesSchere.put("Stein", Double.valueOf(((Integer)playerData.get("playerOutcomeOnSchereStein")).intValue()));
        possibleOutcomesSchere.put("Papier", Double.valueOf(((Integer)playerData.get("playerOutcomeOnScherePapier")).intValue()));
        possibleOutcomes.put("Schere", possibleOutcomesSchere);
        LinkedHashMap<String, Double> possibleOutcomesStein = new LinkedHashMap<String, Double>();
        possibleOutcomesStein.put("Schere", Double.valueOf(((Integer)playerData.get("playerOutcomeOnSteinSchere")).intValue()));
        possibleOutcomesStein.put("Stein", Double.valueOf(((Integer)playerData.get("playerOutcomeOnSteinStein")).intValue()));
        possibleOutcomesStein.put("Papier", Double.valueOf(((Integer)playerData.get("playerOutcomeOnSteinPapier")).intValue()));
        possibleOutcomes.put("Stein", possibleOutcomesStein);
        LinkedHashMap<String, Double> possibleOutcomesPapier = new LinkedHashMap<String, Double>();
        possibleOutcomesPapier.put("Schere", Double.valueOf(((Integer)playerData.get("playerOutcomeOnPapierSchere")).intValue()));
        possibleOutcomesPapier.put("Stein", Double.valueOf(((Integer)playerData.get("playerOutcomeOnPapierStein")).intValue()));
        possibleOutcomesPapier.put("Papier", Double.valueOf(((Integer)playerData.get("playerOutcomeOnPapierPapier")).intValue()));
        possibleOutcomes.put("Papier", possibleOutcomesPapier);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private SSPStrategy getStrategy(Map<String, Object> playerData) {
        return (SSPStrategy)playerData.get("playerStrategy");
    }
}

