package de.schereSteinPapier.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a SSP player.
 */
public interface SSPPlayerBuilder {

    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     *
     * @param newName The name of the player.
     * @return {@code this}
     */
    SSPPlayerBuilder changeName(String newName);

    /**
     * Changes the possible outcomes of the player.
     * <p>
     * There is no default.
     *
     * @param possibleOutcomes The possible outcomes of the player. The key for the first-level map is the answer of the
     *                         first player, the key for the second-level map is the answer of the second player.
     */
    SSPPlayerBuilder changePossibleOutcomes(Map<String, Map<String, Double>> possibleOutcomes);

    /**
     * Builds the player.
     *
     * @return The SSP player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    SSPPlayer build() throws GameException;
}
