/*
 * Decompiled with CFR 0.152.
 */
package de.schereSteinPapier.strategy;

import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPState;
import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.moves.SSPMove;
import de.schereSteinPapier.moves.factory.SSPMoveFactory;
import java.util.Optional;
import java.util.Random;

public class SSPSayEquilibriumStrategy
implements SSPStrategy {
    private static final Random RANDOM = new Random();
    private final SSPMoveFactory moveFactory;

    SSPSayEquilibriumStrategy(SSPMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<SSPMove> weightedRandomAnswer() {
        int weight = RANDOM.nextInt(3);
        if (weight < 1) {
            return Optional.of(this.moveFactory.createSchereMove());
        }
        if (weight < 2) {
            return Optional.of(this.moveFactory.createSteinMove());
        }
        return Optional.of(this.moveFactory.createPapierMove());
    }

    public Optional<SSPMove> computeNextMove(int gameId, SSPPlayer player, SSPState state) {
        return this.weightedRandomAnswer();
    }

    public String toString() {
        return SSPSayEquilibriumStrategy.class.getSimpleName();
    }
}

