package de.schereSteinPapier.domain.factory;

import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.moves.factory.SSPMoveFactory;

/**
 * Represents a factory creating SSP strategies.
 */
public interface SSPStrategyFactory {

    /**
     * Creates a SSP strategy.
     *
     * @param moveFactory The {@link SSPMoveFactory} to use.
     * @return The SSP strategy.
     */
    SSPStrategy create(SSPMoveFactory moveFactory);
}
