package de.fhdw.gaming.ipspiel22.searchtree.domain;
import java.util.List;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
/**
 * Game interface for the MinMax algorithm.
 *
 * @param <P> The type of player.
 * @param <S> The type of state.
 * @param <M> The type of move.
 */
public interface MinMaxGame<P extends Player<P>, S extends State<P, S>, M extends Move<P, S>> {

    /**
     * Function which evaluate the current state of the game into a double for calculations.
     *
     * @return a double value for the current game state.
     */
    double evaluateStateful();
    /**
     * Function to check if the game is over in this current state.
     *
     * @return Boolean (gameOver - true / gameIsPlaying - false).
     */
    boolean isGameOver();
    /**
     * Function to get all possible moves for a player.
     */
    List<M> getPossibleMoves();
    /**
     * Execute a move in the game.
     *
     * @param move the move which should be execute.
     */
    void commitMove(M move) throws GameException;
    /**
     * Undo a move in the game.
     *
     * @param move the move which should be undo.
     */
    void rollbackMove(M move);
}
