/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl.VierGewinntBoardEventProviderImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl.VierGewinntBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class VierGewinntGuiOberserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<VierGewinntGuiOberserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, VierGewinntBoardView> boardViews;

    public VierGewinntGuiOberserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<VierGewinntGuiOberserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, VierGewinntBoardView>();
    }

    static Optional<VierGewinntBoardEventProvider> getEventProvider(int gameId) {
        VierGewinntGuiOberserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        VierGewinntBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new VierGewinntBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        if (game instanceof VGGame) {
            VierGewinntBoardView boardView = new VierGewinntBoardView((VGGame)game);
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        VierGewinntBoardView boardView;
        if (game instanceof VGGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused((VGGame)game);
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        VierGewinntBoardView boardView;
        if (game instanceof VGGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed((VGGame)game);
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        VierGewinntBoardView boardView;
        if (game instanceof VGGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.destroy((VGGame)game);
        }
    }
}

