package de.fhdw.gaming.ipspiel22.vierGewinnt.gui;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntBoardEvent;

/**
 * Provides input from the user interacting with a connect-4 board.
 */
public interface VierGewinntBoardEventProvider {
    /**
     * Waits for a user event and returns it.
     *
     * @param player It is this player's turn.
     * @param state  A copy of the game state.
     * @return The {@link TicTacToeBoardEvent} generated by the user.
     */
    VierGewinntBoardEvent waitForEvent(VGPlayer player, VGState state);

    /**
     * If the provider is currently waiting for a user event, the wait operation will be cancelled.
     */
    void cancelWaiting();
}

