package de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;

/**
 * Class.
 */
public final class VierGewinntMakeMoveBoardEvent implements VierGewinntBoardEvent {

    /**
     * The position of the field selected.
     */
    private final VGPosition fieldposition;

    /**
     * Constructor.
     * 
     * @param fieldposition The position of the field selected.
     */
    public VierGewinntMakeMoveBoardEvent(final VGPosition fieldposition) {
        this.fieldposition = fieldposition;
    }
    
    /**
     * Return the position of the field selected.
     */
    public VGPosition getFieldPosition() {
        return this.fieldposition;
    }
    
    @Override
    public void accept(final VierGewinntBoardEventVisitor visitor) {
        visitor.handleMakeMove(this);
    }

}
