/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.searchtree.domain.MinMaxGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGBoardImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.AbstractVGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG1ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG2ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG3ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG4ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG5ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG6ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG7ColumnMove;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MinMaxViergewinnt
implements MinMaxGame<VGPlayer, VGState, VGMove> {
    private final VGState vgState;
    private final VGBoard inistialBoard;
    private final VGPlayer player;
    private Boolean playercolour;
    private VGMove savedMove;

    public MinMaxViergewinnt(VGState state, VGPlayer player) {
        this.vgState = state;
        this.player = player;
        this.playercolour = player.isUsingRedChips();
        this.inistialBoard = new VGBoardImpl((VGBoardImpl)state.getBoard());
    }

    public double evaluateStateful() {
        double stateful;
        VGFieldState state = this.playercolour != false ? VGFieldState.RED : VGFieldState.YELLOW;
        VGFieldState otherPlayerState = this.playercolour == false ? VGFieldState.RED : VGFieldState.YELLOW;
        ArrayList<Double> checkedStates = new ArrayList<Double>();
        if (this.playercolour.booleanValue() == this.player.isUsingRedChips()) {
            checkedStates.addAll(this.twoCombo(this.vgState.getBoard(), state, 6.0));
            checkedStates.addAll(this.threeCombo(this.vgState.getBoard(), state, 12.0));
            checkedStates.addAll(this.fourCombo(this.vgState.getBoard(), state, 24.0));
            stateful = (Double)Collections.max(checkedStates);
            stateful += this.checkMiddle(this.vgState.getBoard(), this.playercolour);
            ArrayList<Double> firstPossibleMoves = new ArrayList<Double>();
            firstPossibleMoves.add(this.ifThreeWithMove(otherPlayerState, !this.player.isUsingRedChips()));
            firstPossibleMoves.add(this.ifThreeWithMove(state, this.player.isUsingRedChips()));
            firstPossibleMoves.add(this.ifWonWithMove(otherPlayerState, !this.player.isUsingRedChips()));
            firstPossibleMoves.add(this.ifWonWithMove(state, this.player.isUsingRedChips()));
            stateful += ((Double)Collections.max(firstPossibleMoves)).doubleValue();
        } else {
            checkedStates.addAll(this.threeCombo(this.vgState.getBoard(), state, 5.0));
            checkedStates.addAll(this.fourCombo(this.vgState.getBoard(), state, 20.0));
            stateful = (Double)Collections.max(checkedStates);
        }
        return stateful;
    }

    public boolean isGameOver() {
        ArrayList allFields = new ArrayList();
        this.vgState.getBoard().getFields().forEach(allFields::addAll);
        if (allFields.stream().noneMatch(vgField -> vgField.getState().equals((Object)VGFieldState.EMPTY))) {
            return true;
        }
        return this.checkWinner(this.vgState.getBoard(), this.playercolour);
    }

    public List<VGMove> getPossibleMoves() {
        ArrayList<VGMove> movesList = new ArrayList<VGMove>();
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN))) {
            movesList.add(new VG1ColumnMove());
        }
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN))) {
            movesList.add(new VG2ColumnMove());
        }
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN))) {
            movesList.add(new VG3ColumnMove());
        }
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN))) {
            movesList.add(new VG4ColumnMove());
        }
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN))) {
            movesList.add(new VG5ColumnMove());
        }
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN))) {
            movesList.add(new VG6ColumnMove());
        }
        if (Objects.nonNull(this.vgState.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN))) {
            movesList.add(new VG7ColumnMove());
        }
        Collections.shuffle(movesList);
        return movesList;
    }

    public void commitMove(VGMove move) throws GameException {
        VGPlayer playerMove = this.playercolour != false ? this.vgState.getRedPlayer() : this.vgState.getYellowPlayer();
        move.applyTo(this.vgState, playerMove);
        this.playercolour = this.playercolour == false;
        this.savedMove = move;
    }

    public void rollbackMove(VGMove move) {
        if (move instanceof AbstractVGMove) {
            this.vgState.getBoard().getFields().get(((AbstractVGMove)move).getColumnInt() - 1);
            int count = 0;
            VGField field = this.vgState.getBoard().getFields().get(((AbstractVGMove)move).getColumnInt() - 1).get(count);
            while (!field.getState().equals((Object)VGFieldState.EMPTY) && count < 5) {
                field = this.vgState.getBoard().getFields().get(((AbstractVGMove)move).getColumnInt() - 1).get(++count);
            }
            this.vgState.getBoard().getFields().get(((AbstractVGMove)move).getColumnInt() - 1).get(count == 0 ? count : count - 1).setState(VGFieldState.EMPTY);
        }
        this.playercolour = this.playercolour == false;
    }

    private double ifWonWithMove(VGFieldState state, Boolean playercolor) {
        double value = playercolor.booleanValue() == this.player.isUsingRedChips() ? 100.0 : 50.0;
        return this.letsWinIfPossible(state, this.getMoveAsAnswer(this.savedMove), playercolor) != false ? value : 0.0;
    }

    private VGAnswerEnum getMoveAsAnswer(VGMove move) {
        if (move instanceof VG1ColumnMove) {
            return VGAnswerEnum.FIRSTCOLUMN;
        }
        if (move instanceof VG2ColumnMove) {
            return VGAnswerEnum.SECONDCOLUMN;
        }
        if (move instanceof VG3ColumnMove) {
            return VGAnswerEnum.THIRDCOLUMN;
        }
        if (move instanceof VG4ColumnMove) {
            return VGAnswerEnum.FOURTHCOLUMN;
        }
        if (move instanceof VG5ColumnMove) {
            return VGAnswerEnum.FITFHCOLUMN;
        }
        if (move instanceof VG6ColumnMove) {
            return VGAnswerEnum.SIXTHCOLUMN;
        }
        return VGAnswerEnum.SEVENTHCOLUMN;
    }

    private double ifThreeWithMove(VGFieldState state, boolean playercolor) {
        double value = playercolor == this.player.isUsingRedChips() ? 20.0 : 10.0;
        return this.putThreeIfPossible(state, this.getMoveAsAnswer(this.savedMove)) != false ? value : 0.0;
    }

    private Boolean letsWinIfPossible(VGFieldState state, VGAnswerEnum column, Boolean playercolor) {
        VGField field = this.inistialBoard.getNextFieldInColumn(column);
        Boolean won = false;
        if (Objects.nonNull(field)) {
            field.setState(state);
            won = this.checkWinner(this.inistialBoard, playercolor);
            field.setState(VGFieldState.EMPTY);
        }
        return won;
    }

    private Boolean putThreeIfPossible(VGFieldState state, VGAnswerEnum column) {
        VGField field = this.inistialBoard.getNextFieldInColumn(column);
        Boolean won = false;
        if (Objects.nonNull(field)) {
            field.setState(state);
            won = Collections.max(this.threeCombo(this.inistialBoard, state, 20.0)) > 0.0;
            field.setState(VGFieldState.EMPTY);
        }
        return won;
    }

    private boolean checkWinner(VGBoard board, Boolean usingRedChips) {
        VGFieldState state = usingRedChips != false ? VGFieldState.RED : VGFieldState.YELLOW;
        return this.checkHorizontaleLeftToRight(board, state, state, state, state) != false || this.checkVertikaleDownUp(board, state, state, state, state) != false || this.checkDiagonaleDownLeftUpRight(board, state, state, state, state) != false || this.checkDiagonaleDownRightUpLeftght(board, state, state, state, state) != false;
    }

    private Double checkCondition(Boolean condition, Double rating) {
        return condition != false ? rating : 0.0;
    }

    public List<Double> twoCombo(VGBoard board, VGFieldState state, Double rating) {
        ArrayList<Double> checkedStates = new ArrayList<Double>();
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, VGFieldState.EMPTY, state, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, VGFieldState.EMPTY, state, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, VGFieldState.EMPTY, state, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, state, VGFieldState.EMPTY, state, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, state, VGFieldState.EMPTY, state, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, state, VGFieldState.EMPTY, state, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, state, state, VGFieldState.EMPTY, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, state, state, VGFieldState.EMPTY, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, state, state, VGFieldState.EMPTY, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, state, VGFieldState.EMPTY, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, state, VGFieldState.EMPTY, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, state, VGFieldState.EMPTY, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, VGFieldState.EMPTY, VGFieldState.EMPTY, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, VGFieldState.EMPTY, VGFieldState.EMPTY, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, VGFieldState.EMPTY, VGFieldState.EMPTY, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkVertikaleDownUp(board, state, state, VGFieldState.EMPTY, VGFieldState.EMPTY), rating));
        return checkedStates;
    }

    public List<Double> threeCombo(VGBoard board, VGFieldState state, Double rating) {
        ArrayList<Double> checkedStates = new ArrayList<Double>();
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, state, state, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, state, state, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, state, state, VGFieldState.EMPTY, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, state, VGFieldState.EMPTY, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, state, VGFieldState.EMPTY, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, state, VGFieldState.EMPTY, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, VGFieldState.EMPTY, state, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, VGFieldState.EMPTY, state, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, VGFieldState.EMPTY, state, state, state), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownLeftUpRight(board, state, state, state, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkVertikaleDownUp(board, state, state, state, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkDiagonaleDownRightUpLeftght(board, state, state, state, VGFieldState.EMPTY), rating));
        checkedStates.add(this.checkCondition(this.checkHorizontaleLeftToRight(board, state, state, state, VGFieldState.EMPTY), rating));
        return checkedStates;
    }

    public List<Double> fourCombo(VGBoard board, VGFieldState state, Double rating) {
        ArrayList<Double> checkedStates = new ArrayList<Double>();
        checkedStates.add(this.checkDiagonaleDownLeftUpRight(board, state, state, state, state) != false ? rating : 0.0);
        checkedStates.add(this.checkVertikaleDownUp(board, state, state, state, state) != false ? rating : 0.0);
        checkedStates.add(this.checkDiagonaleDownRightUpLeftght(board, state, state, state, state) != false ? rating : 0.0);
        checkedStates.add(this.checkHorizontaleLeftToRight(board, state, state, state, state) != false ? rating : 0.0);
        return checkedStates;
    }

    private double checkMiddle(VGBoard board, boolean usingRedChips) {
        double result = 0.0;
        VGFieldState state = usingRedChips ? VGFieldState.RED : VGFieldState.YELLOW;
        result += board.getFields().get(2).stream().filter(field -> field.getState().equals((Object)state)).mapToDouble(field -> 2.0).sum();
        result += board.getFields().get(3).stream().filter(field -> field.getState().equals((Object)state)).mapToDouble(field -> 5.0).sum();
        return result += board.getFields().get(4).stream().filter(field -> field.getState().equals((Object)state)).mapToDouble(field -> 2.0).sum();
    }

    private Boolean checkHorizontaleLeftToRight(VGBoard board, VGFieldState chip1, VGFieldState chip2, VGFieldState chip3, VGFieldState chip4) {
        for (int i = 0; i < board.getRows(); ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!board.getFieldAt(VGPosition.of(j, i)).getState().equals((Object)chip1) || !board.getFieldAt(VGPosition.of(j + 1, i)).getState().equals((Object)chip2) || !board.getFieldAt(VGPosition.of(j + 2, i)).getState().equals((Object)chip3) || !board.getFieldAt(VGPosition.of(j + 3, i)).getState().equals((Object)chip4)) continue;
                return true;
            }
        }
        return false;
    }

    private Boolean checkVertikaleDownUp(VGBoard board, VGFieldState chip1, VGFieldState chip2, VGFieldState chip3, VGFieldState chip4) {
        for (int i = 0; i < board.getColumns(); ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!board.getFieldAt(VGPosition.of(i, j)).getState().equals((Object)chip1) || !board.getFieldAt(VGPosition.of(i, j + 1)).getState().equals((Object)chip2) || !board.getFieldAt(VGPosition.of(i, j + 2)).getState().equals((Object)chip3) || !board.getFieldAt(VGPosition.of(i, j + 3)).getState().equals((Object)chip4)) continue;
                return true;
            }
        }
        return false;
    }

    private Boolean checkDiagonaleDownLeftUpRight(VGBoard board, VGFieldState chip1, VGFieldState chip2, VGFieldState chip3, VGFieldState chip4) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!board.getFieldAt(VGPosition.of(j, i)).getState().equals((Object)chip1) || !board.getFieldAt(VGPosition.of(j + 1, i + 1)).getState().equals((Object)chip2) || !board.getFieldAt(VGPosition.of(j + 2, i + 2)).getState().equals((Object)chip3) || !board.getFieldAt(VGPosition.of(j + 3, i + 3)).getState().equals((Object)chip4)) continue;
                return true;
            }
        }
        return false;
    }

    private Boolean checkDiagonaleDownRightUpLeftght(VGBoard board, VGFieldState chip1, VGFieldState chip2, VGFieldState chip3, VGFieldState chip4) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 3; j < 7; ++j) {
                if (!board.getFieldAt(VGPosition.of(j, i)).getState().equals((Object)chip1) || !board.getFieldAt(VGPosition.of(j - 1, i + 1)).getState().equals((Object)chip2) || !board.getFieldAt(VGPosition.of(j - 2, i + 2)).getState().equals((Object)chip3) || !board.getFieldAt(VGPosition.of(j - 3, i + 3)).getState().equals((Object)chip4)) continue;
                return true;
            }
        }
        return false;
    }
}

