/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGameBuilder;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGameBuilderFactory;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayerBuilder;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.factory.VGDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.factory.VGStrategyFactory;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.factory.VGStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGGameBuilderImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VGDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class VGGameBuilderFactoryImpl
implements VGGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<VGStrategy> strategies;

    public VGGameBuilderFactoryImpl() {
        this(new VGDefaultStrategyFactoryProvider());
    }

    VGGameBuilderFactoryImpl(VGStrategyFactoryProvider strategyFactoryProvider) {
        VGDefaultMoveFactory moveFactory = new VGDefaultMoveFactory();
        List<VGStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<VGStrategy>();
        for (VGStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Vier gewinnt";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<VGStrategy>(this.strategies);
    }

    @Override
    public VGGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            VGGameBuilderImpl gameBuilder = new VGGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1", Optional.empty());
            VGPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            VGStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2", Optional.of((Boolean)firstPlayerData.get("playerUsingRedChips") == false));
            VGPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            VGStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Vier gewinnt game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title, Optional<Boolean> usingRedChips) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needBoolean("playerUsingRedChips", "Red colour", Optional.of(Boolean.TRUE), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        if (usingRedChips.isPresent()) {
            inputProvider.fixedBoolean("playerUsingRedChips", usingRedChips.get());
        }
        return inputProvider.requestData(title);
    }

    private VGPlayer createPlayer(VGPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        return playerBuilder.changeName((String)playerData.get("playerName")).changeUsingRedChips((Boolean)playerData.get("playerUsingRedChips")).build();
    }

    private VGStrategy getStrategy(Map<String, Object> playerData) {
        return (VGStrategy)playerData.get("playerStrategy");
    }
}

