package de.fhdw.gaming.ipspiel22.vierGewinnt.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Vier gewinnt game.
 */
public interface VGGameBuilder extends GameBuilder {
    /**
     * Creates an {@link VGPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    VGPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    VGGameBuilder addPlayer(VGPlayer player, VGStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */
    VGGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    VGGame build(int id) throws GameException, InterruptedException;
}
