package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.factory;

import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.factory.KopfundZahlMoveFactory;

/**
 * Represents a factory creating strategies for head and tail.
 */
@FunctionalInterface
public interface KopfundZahlStrategyFactory {

    /**
     * Creates a KopfundZahl strategy.
     *
     * @param moveFactory The {@link KopfundZahlMoveFactory} to use.
     * @return The KopfundZahl strategy.
     */
    KopfundZahlStrategy create(KopfundZahlMoveFactory moveFactory);
}
