package de.fhdw.gaming.ipspiel22.vierGewinnt.domain;

import de.fhdw.gaming.core.domain.State;

/**
 * Represents the state of a Vier gewinnt game.
 */
public interface VGState extends State<VGPlayer, VGState> {
    
    /**
     * Returns the board.
     */
    VGBoard getBoard();

    /**
     * Returns the player using red chips.
     */
    VGPlayer getRedPlayer();

    /**
     * Returns the player using yellow chips.
     */
    VGPlayer getYellowPlayer();

    /**
     * Returns the currently active player, i.e. the player that needs to make the next move.
     */
    VGPlayer getCurrentPlayer();
    
    /**
     * Updates the player states after the game has finished, without someone winning. Sets Playerstate to DRAW.
     */
     void gameOver();

}
