package de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;

/**
 * Choosing First Column.
 */
public class VG1ColumnMove extends AbstractVGMove {

    @Override
    public void applyTo(final VGState state, final VGPlayer player) throws GameException {
        state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN).placeToken(player.isUsingRedChips());
    }

    @Override
    public String toString() {
        return "First Column";
    }

    @Override
    public int getColumnInt() {
        return 1;
    }
}
