package de.fhdw.gaming.ipspiel22.VGStrategyEins.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.searchtree.algorithm.MinMaxAlgorithm;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;

/**
 * VGStrategyEins.
 * 
 * @author DonPablo
 *
 */
public class VGStrategyEins implements VGStrategy {

    /**
     * VGMoveFactory.
     */
    private final VGMoveFactory movesFactory;

    /**
     * VGStrategyEins Constructor.
     * 
     * @param moveFactory
     */
    public VGStrategyEins(final VGMoveFactory moveFactory) {
        this.movesFactory = moveFactory;
    }

    @Override
    public Optional<VGMove> computeNextMove(final int gameId, final VGPlayer player, final VGState state)
            throws GameException, InterruptedException {
        final Bewertung vgGame = new Bewertung(player, state, movesFactory);
        final MinMaxAlgorithm<VGPlayer, VGState, VGMove, Bewertung> vg = new MinMaxAlgorithm<>(vgGame);
        return vg.getBestMove(5);
    }

    @Override
    public String toString() {
        return VGStrategyEins.class.getSimpleName();
    }

}
