/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteAnswerEnum;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayerBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl.KopfundZahlundKantePlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class KopfundZahlundKantePlayerBuilderImpl
implements KopfundZahlundKantePlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>>> possibleOutcomes = Optional.empty();

    @Override
    public KopfundZahlundKantePlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public KopfundZahlundKantePlayerBuilder changePossibleOutcomes(Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> newpossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newpossibleOutcomes);
        return this;
    }

    @Override
    public KopfundZahlundKantePlayer build() throws GameException {
        return new KopfundZahlundKantePlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> checkPossibleOutcomes(Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.TAIL, KopfundZahlundKanteAnswerEnum.HEAD);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.TAIL, KopfundZahlundKanteAnswerEnum.EDGE);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.TAIL, KopfundZahlundKanteAnswerEnum.TAIL);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.HEAD, KopfundZahlundKanteAnswerEnum.TAIL);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.HEAD, KopfundZahlundKanteAnswerEnum.HEAD);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.HEAD, KopfundZahlundKanteAnswerEnum.EDGE);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.EDGE, KopfundZahlundKanteAnswerEnum.HEAD);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.EDGE, KopfundZahlundKanteAnswerEnum.TAIL);
        this.checkPossibleOutcome(outcomes, KopfundZahlundKanteAnswerEnum.EDGE, KopfundZahlundKanteAnswerEnum.EDGE);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> outcomes, KopfundZahlundKanteAnswerEnum firstChoice, KopfundZahlundKanteAnswerEnum secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", new Object[]{this.name, firstChoice, secondChoice}));
        }
    }
}

