package de.fhdw.gaming.ipspiel22.gefangenenDilemma.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDState;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.GDMove;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.factory.GDMoveFactory;

/**
 * Implements {@link GDStrategy} by always making a statement.
 */
public class GDStatementStrategy implements GDStrategy {

    /**
     * The factory for creating Gefangenen Dilemma moves.
     */
    private final GDMoveFactory moveFactory;

    /**
     * Creates an {@link GDStatementStrategy}.
     *
     * @param moveFactory The factory for creating Gefangenen Dilemma moves.
     */
    public GDStatementStrategy(final GDMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<GDMove> computeNextMove(final int gameId, final GDPlayer player, final GDState state) {
        return Optional.of(this.moveFactory.createStatementMove());
    }

    @Override
    public String toString() {
        return GDStatementStrategy.class.getSimpleName();
    }
}
