/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntBoardEvent;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl.VierGewinntBoardView;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl.VierGewinntFieldView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;

public final class VierGewinntBoardEventProviderImpl
implements VierGewinntBoardEventProvider {
    private final VierGewinntBoardView boardView;

    public VierGewinntBoardEventProviderImpl(VierGewinntBoardView boardView) {
        this.boardView = boardView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VierGewinntBoardEvent waitForEvent(VGPlayer player, VGState state) {
        Runnable cleanUp;
        Object fieldViews;
        LinkedHashMap<VGPosition, VierGewinntFieldView> emptyFieldViews = new LinkedHashMap<VGPosition, VierGewinntFieldView>();
        for (Map.Entry entry : state.getBoard().getFieldsBeing(VGFieldState.EMPTY).entrySet()) {
            emptyFieldViews.put((VGPosition)entry.getKey(), this.boardView.getFieldView((VGPosition)entry.getKey()).orElseThrow());
        }
        AtomicReference<VierGewinntBoardEvent> event = new AtomicReference<VierGewinntBoardEvent>();
        if (emptyFieldViews.isEmpty()) {
            fieldViews = this.setupInactiveFields(state.getBoard());
            cleanUp = () -> this.cleanUpFields((Collection<? extends VierGewinntFieldView>)fieldViews);
        } else {
            this.setupActiveFields(emptyFieldViews, event);
            cleanUp = () -> this.cleanUpFields(emptyFieldViews.values());
        }
        try {
            this.boardView.getUserInputSemaphore().acquire();
            fieldViews = event.get();
            return fieldViews;
        }
        catch (InterruptedException e) {
            VierGewinntBoardEvent vierGewinntBoardEvent = null;
            return vierGewinntBoardEvent;
        }
        finally {
            Platform.runLater((Runnable)cleanUp);
        }
    }

    private void setupActiveFields(Map<VGPosition, VierGewinntFieldView> emptyFieldViews, AtomicReference<VierGewinntBoardEvent> event) {
        for (Map.Entry<VGPosition, VierGewinntFieldView> entry : emptyFieldViews.entrySet()) {
            VGPosition position = entry.getKey();
            VierGewinntFieldView fieldView = entry.getValue();
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CROSSHAIR);
                fieldView.setHighlighted(true);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        event.set(new VierGewinntMakeMoveBoardEvent(position));
                        this.boardView.getUserInputSemaphore().release();
                    }
                });
            });
        }
    }

    private List<VierGewinntFieldView> setupInactiveFields(VGBoard board) {
        ArrayList fields = new ArrayList();
        board.getFields().forEach(list -> fields.addAll(list));
        ArrayList<VierGewinntFieldView> fieldViews = new ArrayList<VierGewinntFieldView>();
        for (VGField field : fields) {
            VierGewinntFieldView fieldView = this.boardView.getFieldView(field.getPosition()).orElseThrow();
            fieldViews.add(fieldView);
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CLOSED_HAND);
                fieldView.setOnMouseClicked(null);
            });
        }
        return fieldViews;
    }

    private void cleanUpFields(Collection<? extends VierGewinntFieldView> fieldViews) {
        for (VierGewinntFieldView vierGewinntFieldView : fieldViews) {
            vierGewinntFieldView.setCursor(Cursor.DEFAULT);
            vierGewinntFieldView.setHighlighted(false);
            vierGewinntFieldView.setOnMouseClicked(null);
        }
    }

    @Override
    public void cancelWaiting() {
        this.boardView.getUserInputSemaphore().release();
    }
}

