package de.fhdw.gaming.ipspiel23.c4.domain;

/**
 * A performance-friendly, "slim" solution for the connect four game.
 */
public interface IC4SolutionSlim {

    /**
     * The owner of this solution, i.e., the player who has won the game.
     */
    IC4Player getOwner();

    /**
     * The start position of this solution.
     */
    IC4Position getStartPosition();

    /**
     * The end position of this solution.
     */
    IC4Position getEndPosition();

    /**
     * The direction of this solution.
     */
    C4Direction getDirection();

    /**
     * The number of fields in this solution.
     */
    int size();
}
