/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Solution;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import java.util.Optional;

public class C4Solution
implements IC4Solution {
    private final IC4Board board;
    private final IC4SolutionSlim slimSolution;

    public C4Solution(IC4Board board, IC4SolutionSlim slimSolution) {
        this.board = board;
        this.slimSolution = slimSolution;
    }

    @Override
    public IC4Player getOwner() {
        return this.slimSolution.getOwner();
    }

    @Override
    public IC4Position getStartPosition() {
        return this.slimSolution.getStartPosition();
    }

    @Override
    public IC4Position getEndPosition() {
        return this.slimSolution.getEndPosition();
    }

    @Override
    public C4Direction getDirection() {
        return this.slimSolution.getDirection();
    }

    @Override
    public int size() {
        return this.slimSolution.size();
    }

    @Override
    public IC4Field[] getContainingFields() {
        IC4Field[] fields = new IC4Field[this.size()];
        C4Direction dir = this.getDirection();
        Optional<IC4Field> field = this.board.tryGetField(this.getStartPosition());
        for (int i = 0; i < fields.length && field.isPresent(); ++i) {
            fields[i] = field.get();
            field = field.get().tryGetNeighbor(dir);
        }
        return fields;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IC4Solution)) {
            return false;
        }
        IC4Solution other = (IC4Solution)object;
        return this.getOwner().getToken() == other.getOwner().getToken() && (this.getStartPosition().equals(other.getStartPosition()) && this.getEndPosition().equals(other.getEndPosition()) || this.getStartPosition().equals(other.getEndPosition()) && this.getEndPosition().equals(other.getStartPosition())) && this.size() == other.size();
    }

    public int hashCode() {
        int hash = 527;
        hash += this.board.hashCode();
        hash = hash * 31 + this.slimSolution.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("C4Solution[owner: %s, start: %s, end: %s, direction: %s]", new Object[]{this.getOwner(), this.getStartPosition(), this.getEndPosition(), this.getDirection()});
    }
}

