/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.strategies.internals;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.c4.domain.C4PositionMaterializer;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import java.util.Optional;
import java.util.Random;

public class C4RandomMoveStrategy
implements IC4Strategy {
    private static final Random RANDOM = new Random();
    private final IC4MoveFactory moveFactory;

    public C4RandomMoveStrategy(IC4MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<IC4Move> computeNextMove(int gameId, IC4Player player, IC4State state) throws GameException, InterruptedException {
        long[] legalPositions = new long[state.getBoard().getColumnCount()];
        int positionsWritten = state.getBoard().getInternalBoard().getLegalDematPositionsUnsafe(legalPositions);
        if (positionsWritten == 0) {
            return Optional.empty();
        }
        int randomIndex = RANDOM.nextInt(positionsWritten);
        long randomDematerializedPosition = legalPositions[randomIndex];
        IC4Position randomPosition = C4PositionMaterializer.rematerialize(randomDematerializedPosition);
        IC4Move move = this.moveFactory.createMove(player, randomPosition);
        return Optional.of(move);
    }

    public String toString() {
        return C4RandomMoveStrategy.class.getSimpleName();
    }
}

