package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import java.util.Map;
import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaGame;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaMoveChecker;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaCooperateMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaDefectMove;

/**
 * Implements the Dilemma game.
 */
public class DilemmaGame 
        extends DefaultGame<IDilemmaPlayer, IDilemmaState, IDilemmaMove, IDilemmaStrategy> 
        implements IDilemmaGame {
    
    /**
     * yay it's your friendly neighborhood random number generator :).
     */
    private static final Random RANDOM = new Random();
            
    /**
     * Creates a Dilemma game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    DilemmaGame(final int id, final IDilemmaState initialState, final Map<String, IDilemmaStrategy> strategies,
            final long maxComputationTimePerMove, final IDilemmaMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
    }

    @Override
    public Optional<IDilemmaMove> chooseRandomMove(final IDilemmaPlayer player, final IDilemmaState state) {
        return Optional.of(RANDOM.nextBoolean()
            ? new DilemmaDefectMove()
            : new DilemmaCooperateMove());
    }
    
    @Override
    public String toString() {
        return String.format("DilemmaGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
