package de.fhdw.gaming.ipspiel23.freizeitgestaltung.strategy;

import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgStrategy;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.Answer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.factory.AnswerFactory;

/**
 * Implements a mixed strategy which aims to create a balance between the players outcomes. 
 */
public class MixedStrategy implements FzgStrategy {

    /**
     * Random number generator for implementing a mixed strategy.
     */
    private static final Random RANDOM = new Random();

    /**
     * Factory for creating answers.
     */
    private final AnswerFactory answerFactory;
    
    /**
     * Constructor.
     * @param answerFactory {@link AnswerFactory} factory to create the answer.
     */
    public MixedStrategy(final AnswerFactory answerFactory) {
        this.answerFactory = answerFactory;
    }
    
    @Override
    public Optional<Answer> computeNextMove(final int gameId, final FzgPlayer player, final FzgState state)
            throws GameException, InterruptedException {
        final FzgPlayer otherPlayer;
        if (state.getFirstPlayer().equals(player)) {
            otherPlayer = state.getSecondPlayer();
        } else {
            otherPlayer = state.getFirstPlayer();
        }
        
        final var outcomes = otherPlayer.getPossibleOutcomes();
        final double a11 = outcomes.get(AnswerOptions.CINEMA).get(AnswerOptions.CINEMA);
        final double a12 = outcomes.get(AnswerOptions.CINEMA).get(AnswerOptions.FOOTBALL);
        final double a21 = outcomes.get(AnswerOptions.FOOTBALL).get(AnswerOptions.CINEMA);
        final double a22 = outcomes.get(AnswerOptions.FOOTBALL).get(AnswerOptions.FOOTBALL);
        
        final double cinemaLikeliness = (a12 + a22) / (a11 - a12 - a21 + a22);
        final double percentage = RANDOM.nextDouble();
        if (percentage <= cinemaLikeliness) {
            return Optional.of(this.answerFactory.createCinemaAnswer());
        }
        return Optional.of(this.answerFactory.createFootballAnswer());
    }
    
    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}
