/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.gui.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class C4FieldView
extends Region {
    private Optional<IC4Player> occupier;
    private final Canvas canvas;
    private final ObjectProperty<Duration> moveDuration;
    private boolean highlighted;

    public C4FieldView(Optional<IC4Player> occupier) {
        this.occupier = occupier;
        this.moveDuration = new SimpleObjectProperty((Object)Duration.millis((double)500.0));
        this.highlighted = false;
        this.canvas = new Canvas(){

            public boolean isResizable() {
                return true;
            }

            public double prefWidth(double height) {
                return 0.0;
            }

            public double prefHeight(double width) {
                return 0.0;
            }

            public double maxWidth(double height) {
                return Double.POSITIVE_INFINITY;
            }

            public double maxHeight(double width) {
                return Double.POSITIVE_INFINITY;
            }
        };
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.setMinSize(50.0, 50.0);
        this.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    public void setOccupier(Optional<IC4Player> occupier) {
        this.occupier = occupier;
        this.draw();
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.draw();
    }

    private void draw() {
        block5: {
            double margin;
            GraphicsContext gc;
            double size;
            block4: {
                size = this.getWidth();
                gc = this.canvas.getGraphicsContext2D();
                gc.setFill((Paint)(this.highlighted ? Color.LIGHTSLATEGRAY : Color.DARKGRAY));
                gc.fillRect(0.0, 0.0, size, size);
                gc.setFill((Paint)Color.BLACK);
                gc.beginPath();
                gc.moveTo(0.0, 0.0);
                gc.lineTo(size, 0.0);
                gc.lineTo(size, size);
                gc.lineTo(0.0, size);
                gc.lineTo(0.0, 0.0);
                gc.closePath();
                gc.stroke();
                margin = size * 0.1;
                if (!this.occupier.isPresent()) break block4;
                switch (this.occupier.get().getToken()) {
                    case 1: {
                        gc.setFill((Paint)Color.RED);
                        gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                        break block5;
                    }
                    case 2: {
                        gc.setFill((Paint)Color.YELLOW);
                        gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
                        break block5;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unknown playerToken", new Object[0]));
                    }
                }
            }
            gc.setFill((Paint)Color.WHITE);
            gc.fillOval(margin, margin, size - 2.0 * margin, size - 2.0 * margin);
        }
    }
}

