/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzer;
import java.util.Set;

public class C4SolutionAnalyzerVertical
extends C4SolutionAnalyzer {
    private final boolean[] isColumnBlacklisted = new boolean[this.colMax()];

    public C4SolutionAnalyzerVertical(C4BoardSlim board) {
        super(board, C4Direction.NORTH);
    }

    @Override
    public void resetCache() {
        for (int i = 0; i < this.isColumnBlacklisted.length; ++i) {
            this.isColumnBlacklisted[i] = false;
        }
    }

    @Override
    public IC4SolutionSlim tryFindFirstSolution(IC4SolutionSlim currentSolution, boolean updateCache) {
        if (currentSolution != null) {
            return currentSolution;
        }
        for (int col = 0; col < this.colMax(); ++col) {
            if (this.isColumnBlacklisted[col]) continue;
            boolean inAir = false;
            int count = 0;
            int lastToken = 0;
            for (int row = this.rowMax() - 1; row >= 0 && !inAir; --row) {
                int token = this.board().getTokenUnsafe(row, col);
                if ((count = C4SolutionAnalyzerVertical.countConsecutivesBranchless(count, token, lastToken)) >= this.targetCount()) {
                    return this.scanRemaining(token, row, col);
                }
                lastToken = token;
                inAir = token == 0;
            }
            this.isColumnBlacklisted[col] = updateCache && !inAir;
        }
        return null;
    }

    @Override
    public void findAllSolutions(Set<IC4SolutionSlim> resultSet, boolean updateCache) {
        for (int col = 0; col < this.colMax(); ++col) {
            if (this.isColumnBlacklisted[col]) continue;
            boolean inAir = false;
            int count = 0;
            int lastToken = 0;
            boolean colContainsSolution = false;
            for (int row = this.rowMax() - 1; row >= 0 && !inAir; --row) {
                int token = this.board().getTokenUnsafe(row, col);
                if ((count = C4SolutionAnalyzerVertical.countConsecutivesBranchless(count, token, lastToken)) >= this.targetCount()) {
                    C4SolutionSlim solution = this.scanRemaining(token, row, col);
                    resultSet.add(solution);
                    count = 0;
                    colContainsSolution = true;
                    row = solution.getRowIndexEnd();
                }
                lastToken = token;
                inAir = token == 0;
            }
            this.isColumnBlacklisted[col] = updateCache && !inAir && !colContainsSolution;
        }
    }

    @Override
    protected C4SolutionSlim scanRemaining(int token, int startRow, int startCol) {
        int row;
        for (row = startRow - 1; row >= 0 && this.board().getTokenUnsafe(row, startCol) == token; --row) {
        }
        return this.solutionOf(token, ++row, startCol, this.board().getMinimumSolutionSize() + startRow - row);
    }
}

