package de.fhdw.gaming.ipspiel23.dilemma.strategy;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;

/**
 * Represents a factory creating Dilemma strategies.
 */
public interface IDilemmaStrategyFactory {

    /**
     * Creates a Dilemma strategy.
     *
     * @param moveFactory The {@link IDilemmaMoveFactory} to use.
     * @return The Dilemma strategy.
     */
    IDilemmaStrategy create(IDilemmaMoveFactory moveFactory);
}
