/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.pavlov;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import java.util.Optional;

public class DilemmaPavlovStrategy
extends DilemmaMemoryStrategy {
    protected DilemmaPavlovStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) throws GameException, InterruptedException {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        IDilemmaMoveFactory moveFactory = this.getMoveFactory();
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        DilemmaRoundData previousRound = (DilemmaRoundData)memory.getRound(0, true);
        return Optional.of(previousRound.player1Data().answer().equals((Object)previousRound.player2Data().answer()) ? moveFactory.createCooperateMove() : moveFactory.createDefectMove());
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}

