package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.random;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory;

/**
 * Implements {@link IDilemmaStrategyFactory} by creating a {@link DilemmaCooperateStrategy}.
 */
public class DilemmaRandomStrategyFactory implements IDilemmaStrategyFactory {

    /**
     * Creates strategy which is visible for the player to chose.
     */
    @Override
    public IDilemmaStrategy create(final IDilemmaMoveFactory moveFactory) {
        return new DilemmaRandomStrategy(moveFactory);
    }
}
