/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaGameBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaGameBuilderFactory;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaDefaultMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.DilemmaDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactoryProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class DilemmaGameBuilderFactory
implements IDilemmaGameBuilderFactory {
    private static final int MIN_MAX_NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<IDilemmaStrategy> strategies;

    public DilemmaGameBuilderFactory() {
        this(new DilemmaDefaultStrategyFactoryProvider());
    }

    DilemmaGameBuilderFactory(IDilemmaStrategyFactoryProvider strategyFactoryProvider) {
        DilemmaDefaultMoveFactory moveFactory = new DilemmaDefaultMoveFactory();
        List<IDilemmaStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<IDilemmaStrategy>();
        for (IDilemmaStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Gefangenen-Dilemma";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<IDilemmaStrategy>(this.strategies);
    }

    @Override
    public IDilemmaGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            DilemmaGameBuilder gameBuilder = new DilemmaGameBuilder();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds ", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            IDilemmaPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            IDilemmaStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            IDilemmaPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            IDilemmaStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Dilemma game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnCooperateCooperate", "Player's outcome on cooperate/cooperate", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnCooperateDefect", "Player's outcome on cooperate/defect", Optional.of(-10), new Validator[0]).needInteger("playerOutcomeOnDefectCooperate", "Player's outcome on defect/cooperate", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnDefectDefect", "Player's outcome on defect/defect", Optional.of(-8), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private IDilemmaPlayer createPlayer(IDilemmaPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> possibleOutcomes = new LinkedHashMap<DilemmaAnswerType, Map<DilemmaAnswerType, Double>>();
        LinkedHashMap<DilemmaAnswerType, Double> possibleOutcomesNo = new LinkedHashMap<DilemmaAnswerType, Double>();
        possibleOutcomesNo.put(DilemmaAnswerType.COOPERATE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnCooperateCooperate")).intValue()));
        possibleOutcomesNo.put(DilemmaAnswerType.DEFECT, Double.valueOf(((Integer)playerData.get("playerOutcomeOnCooperateDefect")).intValue()));
        possibleOutcomes.put(DilemmaAnswerType.COOPERATE, possibleOutcomesNo);
        LinkedHashMap<DilemmaAnswerType, Double> possibleOutcomesYes = new LinkedHashMap<DilemmaAnswerType, Double>();
        possibleOutcomesYes.put(DilemmaAnswerType.COOPERATE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnDefectCooperate")).intValue()));
        possibleOutcomesYes.put(DilemmaAnswerType.DEFECT, Double.valueOf(((Integer)playerData.get("playerOutcomeOnDefectDefect")).intValue()));
        possibleOutcomes.put(DilemmaAnswerType.DEFECT, possibleOutcomesYes);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private IDilemmaStrategy getStrategy(Map<String, Object> playerData) {
        return (IDilemmaStrategy)playerData.get("playerStrategy");
    }
}

