package de.fhdw.gaming.ipspiel23.c4.gststrategy;

import java.util.Set;
import java.util.stream.Collectors;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Solution;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;

/**
 * .
 */
public class SimpleC4GSTEvaluation {

    /**
     * .
     * @param state
     * @return
     */
    public Integer evalC4State(IC4State state) {

        int evaluation = 0;

        final Set<IC4Solution> playerASolutions = state.getBoard().findAllSolutions()
                .stream()
                .filter(s -> s.getOwner().equals(state.getCurrentPlayer()))
                .collect(Collectors.toSet());

        final Set<IC4Solution> playerBSolutions = state.getBoard().findAllSolutions()
                .stream()
                .filter(s -> !s.getOwner().equals(state.getCurrentPlayer()))
                .collect(Collectors.toSet());

        final int playerASolutionCount = playerASolutions.size();
        final int playerBSolutionCount = playerBSolutions.size();

        evaluation += playerASolutionCount * 1000;
        evaluation -= playerBSolutionCount * 1000;

        evaluation *= state.getBoard().countEmptyPositions();
        
        
        
        
        return evaluation;

    }

}
